# Microsoft Azure AD Users by Graph

> Note: The use of the scripts requires the PowerShell Microsoft.Graph.Users

+ [Get-MGUUser.ps1](./Get-MGUUser.ps1)

  Retrieve the properties and relationships of user object

+ [Get-MGUUserCount.ps1](./Get-MGUUserCount.ps1)

  Get the number of the resource

+ [Get-MGUUserCreatedObject.ps1](./Get-MGUUserCreatedObject.ps1)
        
  Returns directory objects that were created by the use

+ [Get-MGUUserDirectReportAsUser.ps1](./Get-MGUUserDirectReportAsUser.ps1)

  Returns users and contacts that report to the user

+ [Get-MGUUserDirectReportCount.ps1](./Get-MGUUserDirectReportCount.ps1)

  Get the number of the resource

+ [Get-MGUUserExtension.ps1](./Get-MGUUserExtension.ps1)

  Returns a collection of open extensions defined for the user

+ [Get-MGUUserLicenseDetail.ps1](./Get-MGUUserLicenseDetail.ps1)

  Returns collection of this user's license details

+ [Get-MgUserMailboxSetting.ps1](./Get-MgUserMailboxSetting.ps1)

  Returns user or contact that is this user's manager 

+ [Get-MGUUserManager.ps1](./Get-MGUUserManager.ps1)

  Returns user or contact that is this user's manager

+ [Get-MGUUserMemberOf.ps1](./Get-MGUUserMemberOf.ps1)

  Returns the memberships of the user

+ [Get-MGUUserMemberOfCount.ps1](./Get-MGUUserMemberOfCount.ps1)

  Get the number of the resource

+ [Get-MGUUserOAuthPermissionGrant.ps1](./Get-MGUUserOAuthPermissionGrant.ps1)

  Returns oauth2PermissionGrants from users

+ [Get-MGUUserOutlookMasterCategory.ps1](./Get-MGUUserOutlookMasterCategory.ps1)

  Returns list of categories defined for the user

+ [Get-MGUUserOutlookMasterCategoryCount.ps1](./Get-MGUUserOutlookMasterCategoryCount.ps1)

  Get the number of the resource

+ [Get-MGUUserOwnedDevice.ps1](./Get-MGUUserOwnedDevice.ps1)

  Returns devices that are owned by the user

+ [Get-MGUUserOwnedDeviceAsDevice.ps1](./Get-MGUUserOwnedDeviceAsDevice.ps1)

  Returns devices that are owned by the user, as device

+ [Get-MGUUserOwnedDeviceCount.ps1](./Get-MGUUserOwnedDeviceCount.ps1)

  Get the number of the resource

+ [Get-MGUUserOwnedObject.ps1](./Get-MGUUserOwnedObject.ps1)

  Returns directory objects that are owned by the user

+ [Get-MGUUserOwnedObjectAsApplication.ps1](./Get-MGUUserOwnedObjectAsApplication.ps1)

  Returns directory objects that are owned by the user, as application
  
+ [Get-MGUUserOwnedObjectAsGroup.ps1](./Get-MGUUserOwnedObjectAsGroup.ps1)

  Returns directory objects that are owned by the user, as group

+ [Get-MGUUserOwnedObjectCount.ps1](./Get-MGUUserOwnedObjectCount.ps1)

  Get the number of the resource

+ [Get-MGUUserPhoto.ps1](./Get-MGUUserPhoto.ps1)

  Returns directory objects that are owned by the user

+ [Get-MGUUserPhotoContent.ps1](./Get-MGUUserPhotoContent.ps1)

  Exports user's profile photo

+ [Get-MGUUserRegisteredDevice.ps1](./Get-MGUUserRegisteredDevice.ps1)

    Returns devices that are registered for the user

+ [Get-MGUUserRegisteredDeviceAsDevice.ps1](./Get-MGUUserRegisteredDeviceAsDevice.ps1)

    Returns devices that are registered for the user, as device

+ [Get-MGUUserRegisteredDeviceCount.ps1](./Get-MGUUserRegisteredDeviceCount.ps1)

    Get the number of the resource

+ [Get-MGUUserSetting.ps1](./Get-MGUUserSetting.ps1)

  Returns settings for the user

+ [Get-MGUUserSponsor.ps1](./Get-MGUUserSponsor.ps1)

  The users and groups responsible for this guest user's privileges in the tenant

+ [Get-MGUUserTodoList.ps1](./Get-MGUUserTodoList.ps1)

  Returns task lists in the users mailbox

+ [Get-MGUUserTodoListExtension.ps1](./Get-MGUUserTodoListExtension.ps1)

  Collection of open extensions defined for the task list

+ [Get-MGUUserTodoTaskLinkedResource.ps1](./Get-MGUUserTodoTaskLinkedResource.ps1)

  Read the properties and relationships of a linkedResource object

+ [Get-MGUUserTodoTask.ps1](./Get-MGUUserTodoTask.ps1)

  Returns tasks in this task list 

+ [Get-MGUUserTodoTaskAttachment.ps1](./Get-MGUUserTodoTaskAttachment.ps1)

  Read the properties and relationships of a taskFileAttachment object

+ [Get-MGUUserTodoTaskAttachmentCount.ps1](./Get-MGUUserTodoTaskAttachmentCount.ps1)

  Get the number of the resource

+ [Get-MGUUserTodoTaskAttachmentContent.ps1](./Get-MGUUserTodoTaskAttachmentContent.ps1)

  Get media content for the navigation property attachments from users   

+ [Get-MGUUserTodoTaskChecklistItem.ps1](./Get-MGUUserTodoTaskChecklistItem.ps1)

  Read the properties and relationships of a taskFileAttachment object 

+ [Get-MGUUserTodoTaskExtension.ps1](./Get-MGUUserTodoTaskExtension.ps1)

  Collection of open extensions defined for the task  

+ [Get-MGUUserTransitiveMemberOf.ps1](./Get-MGUUserTransitiveMemberOf.ps1)

  Returns groups, including nested groups, and directory roles that a user is a member of 

+ [Get-MGUUserTransitiveMemberOfCount.ps1](./Get-MGUUserTransitiveMemberOfCount.ps1)

  Get the number of the resource

+ [New-MGUUser.ps1](./New-MGUUser.ps1)

  Creates a User

+ [New-MGUUserExtension.ps1](./New-MGUUserExtension.ps1)

  Create new navigation property to extensions for users

+ [New-MGUUserOutlookMasterCategory.ps1](./New-MGUUserOutlookMasterCategory.ps1)

  Create an outlookCategory object in the user's master list of categories

+ [New-MGUUserTodoList.ps1](./New-MGUUserTodoList.ps1)

  Creates task list in the users mailbox

+ [New-MGUUserTodoListExtension.ps1](./New-MGUUserTodoListExtension.ps1)

  Create new navigation property to extensions for users

+ [New-MGUUserTodoListTask.ps1](./New-MGUUserTodoListTask.ps1)

  Creates task in this task list

+ [New-MGUUserTodoListTaskAttachment.ps1](./New-MGUUserTodoListTaskAttachment.ps1)

  Add a new taskFileAttachment object to a todoTask

+ [New-MGUUserTodoListTaskCheckListItem.ps1](./New-MGUUserTodoListTaskCheckListItem.ps1)

  Create a new checklistItem object

+ [New-MGUUserTodoListTaskExtension.ps1](./New-MGUUserTodoListTaskExtension.ps1)

  Create new navigation property to extensions for users

+ [New-MGUUserTodoListTaskLinkedResource.ps1](./New-MGUUserTodoListTaskLinkedResource.ps1)

  Creates resource linked to the task

+ [Remove-MGUUser.ps1](./Remove-MGUUser.ps1)

  Removes a User

+ [Remove-MGUUserExtension.ps1](./Remove-MGUUserExtension.ps1)

  Remove navigation property from user

+ [Remove-MGUUserLicenseDetail.ps1](./Remove-MGUUserLicenseDetail.ps1)

  Delete navigation property licenseDetails for users

+ [Remove-MGUUserManager.ps1](./Remove-MGUUserManager.ps1)

  Removes user or contact that is this user's manager

+ [Remove-MGUUserOutlookMasterCategory.ps1](./Remove-MGUUserOutlookMasterCategory.ps1)

  Removes category defined for the user

+ [Remove-MGUUserPhoto.ps1](./Remove-MGUUserPhoto.ps1)

  Delete navigation property photo for users

+ [Remove-MGUUserTodoList.ps1](./Remove-MGUUserTodoList.ps1)

  Removes task list in the users mailbox

+ [Remove-MGUUserTodoListExtension.ps1](./Remove-MGUUserTodoListExtension.ps1)

  Delete navigation property extensions for users

+ [Remove-MGUUserTodoListTask.ps1](./Remove-MGUUserTodoListTask.ps1)

  Removes task in this task list

+ [Remove-MGUUserTodoListTaskChecklistItem.ps1](./Remove-MGUUserTodoListTaskChecklistItem.ps1)

  Delete a checklistItem object

+ [Remove-MGUUserTodoListTaskExtension.ps1](./Remove-MGUUserTodoListTaskExtension.ps1)

  Delete navigation property extensions for users

+ [Remove-MGUUserTodoListTaskLinkedResource.ps1](./Remove-MGUUserTodoListTaskLinkedResource.ps1)

  Removes resource linked to the task

+ [Revoke-MGUUserSignInSession.ps1](./Revoke-MGUUserSignInSession.ps1)

  Invalidates all the refresh tokens issued to applications for a user

+ [Set-MGUUser.ps1](./Set-MGUUser.ps1)

  Updates a User

+ [Set-MGUUserExtension.ps1](./Set-MGUUserExtension.ps1)

  Sets the navigation property extensions in user

+ [Set-MGUUserLicenseDetail.ps1](./Set-MGUUserLicenseDetail.ps1)

  Update the navigation property licenseDetails in users

+ [Set-MGUUserMailboxSetting.ps1](./Set-MGUUserMailboxSetting.ps1)

  Updates settings for the primary mailbox of the user

+ [Set-MGUUserManager.ps1](./Set-MGUUserManager.ps1)

  Sets user's manager

+ [Set-MGUUserOutlookMasterCategory.ps1](./Set-MGUUserOutlookMasterCategory.ps1)

  Updates category defined for the user

+ [Set-MGUUserPhotoContent.ps1](./Set-MGUUserPhotoContent.ps1)

  Sets user's profile photo

+ [Set-MGUUserSetting.ps1](./Set-MGUUserSetting.ps1)

  Updates settings for the user

+ [Set-MGUUserTodoList.ps1](./Set-MGUUserTodoList.ps1)

  Updates task list in the users mailbox

+ [Set-MGUUserTodoListExtension.ps1](./Set-MGUUserTodoListExtension.ps1)

  Update the navigation property extensions in users

+ [Set-MGUUserTodoListTask.ps1](./Set-MGUUserTodoListTask.ps1)

  Updates task in this task list

+ [Set-MGUUserTodoListTaskChecklistItem.ps1](./Set-MGUUserTodoListTaskChecklistItem.ps1)

  Update the properties of a checklistItem object

+ [Set-MGUUserTodoListTaskExtension.ps1](./Set-MGUUserTodoListTaskExtension.ps1)

  Update the navigation property extensions in users

+ [Set-MGUUserTodoListTaskLinkedResource.ps1](./Set-MGUUserTodoListTaskLinkedResource.ps1)

  Updates resource linked to the task

+ [Set-MGUUserTodoTaskAttachmentContent.ps1](./Set-MGUUserTodoTaskAttachmentContent.ps1)

  Update media content for the navigation property attachments in users

## [Queries](./_QUERY_)

+ Search users
+ Search user Outlook master categories
+ Search user todo task lists
+ Search user todo task list attachments
+ Search user todo task list tasks 
+ Search user todo task list check list items 
+ Search user todo task list task linked resources 